// SYSPARAM.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"
#include "SYSPARAM.h"
#include "DEMODlg.h "

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

SYSPARA syspara;
extern  int devnum;
/////////////////////////////////////////////////////////////////////////////
// CSYSPARAM dialog


CSYSPARAM::CSYSPARAM(CWnd* pParent /*=NULL*/)
	: CDialog(CSYSPARAM::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSYSPARAM)
	m_lPusleUnit = 0;
	m_fHomeAddtime = 0.0f;
	m_fHomeRunSpd = 0.0f;
	m_fHomeStartSpd = 0.0f;
	m_fSearchRang = 0.0f;
	m_fSearchSpd = 0.0f;
	m_fWorkAddtime = 0.0f;
	m_fWorkRunSpd = 0.0f;
	m_fWorkStartSpd = 0.0f;
	m_nAxisNum = 0;
	m_nDirLogic = -1;
	m_nHomeLevel = -1;
	m_nLimitLevel = -1;
	m_nPulseLog = -1;
	m_nPulseMode = -1;
	m_nZPhasicLevel = -1;
	m_bLimitN = FALSE;
	m_bLimitP = FALSE;
	m_bZPhasic = FALSE;
	m_homestep = 0;
	m_bhomeaxis = FALSE;
	m_bHomeStop0 = FALSE;
	m_enbroadcast = 1;
	m_alarm = FALSE;
	m_alarmlogic = 0;
	m_alarm_out = 34;
	m_alarm_out_logic = 1;
	//}}AFX_DATA_INIT
}


void CSYSPARAM::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSYSPARAM)
	DDX_Text(pDX, IDC_PULSE_UNIT, m_lPusleUnit);
	DDX_Text(pDX, IDC_HOME_ADD_TIME, m_fHomeAddtime);
	DDX_Text(pDX, IDC_HOME_RUN_SPEED, m_fHomeRunSpd);
	DDX_Text(pDX, IDC_HOME_START_SPEED, m_fHomeStartSpd);
	DDX_Text(pDX, IDC_SEARCH_RANGE, m_fSearchRang);
	DDX_Text(pDX, IDC_SEARCH_SPEED, m_fSearchSpd);
	DDX_Text(pDX, IDC_WORK_ADD_TIME, m_fWorkAddtime);
	DDX_Text(pDX, IDC_WORK_RUN_SPEED, m_fWorkRunSpd);
	DDX_Text(pDX, IDC_WORK_START_SPEED, m_fWorkStartSpd);
	DDX_Radio(pDX, IDC_RADIO_AXIS_X, m_nAxisNum);
	DDX_Radio(pDX, IDC_RADIO_DIRLOGIC0, m_nDirLogic);
	DDX_Radio(pDX, IDC_RADIO_HOME_LEVEL0, m_nHomeLevel);
	DDX_Radio(pDX, IDC_RADIO_LMT_LEVEL0, m_nLimitLevel);
	DDX_Radio(pDX, IDC_RADIO_PULSELOG0, m_nPulseLog);
	DDX_Radio(pDX, IDC_RADIO_PULSEMODE0, m_nPulseMode);
	DDX_Radio(pDX, IDC_RADIO_ZPHASIC_LEVEL0, m_nZPhasicLevel);
	DDX_Check(pDX, IDC_CHECK_LIMITN, m_bLimitN);
	DDX_Check(pDX, IDC_CHECK_LIMITP, m_bLimitP);
	DDX_Check(pDX, IDC_CHECK_ZPHASIC, m_bZPhasic);
	DDX_Text(pDX, IDC_STEP, m_homestep);
	DDV_MinMaxByte(pDX, m_homestep, 0, 3);
	DDX_Check(pDX, IDC_CHECK_BHOME, m_bhomeaxis);
	DDX_Check(pDX, IDC_CHECK_HOME, m_bHomeStop0);
	DDX_Radio(pDX, IDC_ENBROADCAST, m_enbroadcast);
	DDX_Check(pDX, IDC_ALARM, m_alarm);
	DDX_Radio(pDX, IDC_RADIO5, m_alarmlogic);
	DDX_Text(pDX, IDC_ALARMOUT, m_alarm_out);
	DDV_MinMaxInt(pDX, m_alarm_out, 0, 17);
	DDX_Radio(pDX, IDC_ALARMOUTLOGIC, m_alarm_out_logic);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSYSPARAM, CDialog)
	//{{AFX_MSG_MAP(CSYSPARAM)
	ON_BN_CLICKED(IDC_BTN_LOADFSPARAM, OnBtnLoadfsparam)
	ON_BN_CLICKED(IDC_BTN_WRTFSPARAM, OnBtnWrtfsparam)
	ON_WM_CREATE()
	ON_BN_CLICKED(IDC_RADIO_AXIS_X, OnRadioAxisX)
	ON_BN_CLICKED(IDC_RADIO_AXIS_Y, OnRadioAxisY)
	ON_BN_CLICKED(IDC_RADIO_AXIS_Z, OnRadioAxisZ)
	ON_BN_CLICKED(IDC_RADIO_AXIS_A, OnRadioAxisA)
	ON_BN_CLICKED(IDC_CHECK_LIMITP, OnCheckLimitp)
	ON_BN_CLICKED(IDC_CHECK_LIMITN, OnCheckLimitn)
	ON_BN_CLICKED(IDC_CHECK_HOME, OnCheckHome)
	ON_BN_CLICKED(IDC_CHECK_ZPHASIC, OnCheckZphasic)
	ON_BN_CLICKED(IDC_RADIO_PULSEMODE0, OnRadioPulsemode0)
	ON_BN_CLICKED(IDC_RADIO_PULSEMODE1, OnRadioPulsemode1)
	ON_BN_CLICKED(IDC_RADIO_PULSELOG0, OnRadioPulselog0)
	ON_BN_CLICKED(IDC_RADIO_PULSELOG1, OnRadioPulselog1)
	ON_BN_CLICKED(IDC_RADIO_DIRLOGIC0, OnRadioDirlogic0)
	ON_BN_CLICKED(IDC_RADIO_DIRLOGIC1, OnRadioDirlogic1)
	ON_BN_CLICKED(IDC_RADIO_LMT_LEVEL0, OnRadioLmtLevel0)
	ON_BN_CLICKED(IDC_RADIO_LMT_LEVEL1, OnRadioLmtLevel1)
	ON_BN_CLICKED(IDC_RADIO_HOME_LEVEL0, OnRadioHomeLevel0)
	ON_BN_CLICKED(IDC_RADIO_HOME_LEVEL1, OnRadioHomeLevel1)
	ON_BN_CLICKED(IDC_RADIO_ZPHASIC_LEVEL0, OnRadioZphasicLevel0)
	ON_BN_CLICKED(IDC_RADIO_ZPHASIC_LEVEL1, OnRadioZphasicLevel1)
	ON_EN_CHANGE(IDC_HOME_START_SPEED, OnChangeHomeStartSpeed)
	ON_EN_CHANGE(IDC_WORK_START_SPEED, OnChangeWorkStartSpeed)
	ON_EN_CHANGE(IDC_HOME_RUN_SPEED, OnChangeHomeRunSpeed)
	ON_EN_CHANGE(IDC_WORK_RUN_SPEED, OnChangeWorkRunSpeed)
	ON_EN_CHANGE(IDC_WORK_ADD_TIME, OnChangeWorkAddTime)
	ON_EN_CHANGE(IDC_HOME_ADD_TIME, OnChangeHomeAddTime)
	ON_EN_CHANGE(IDC_SEARCH_SPEED, OnChangeSearchSpeed)
	ON_EN_CHANGE(IDC_SEARCH_RANGE, OnChangeSearchRange)
	ON_EN_CHANGE(IDC_PULSE_UNIT, OnChangePulseUnit)
	ON_BN_CLICKED(IDC_CHECK_BHOME, OnCheckBhome)
	ON_EN_CHANGE(IDC_STEP, OnChangeStep)
	ON_BN_CLICKED(IDC_RADIO5, OnALARM_LOGIL)
	ON_BN_CLICKED(IDC_RADIO6, OnALARM_LOGIH)
	ON_BN_CLICKED(IDC_ENBROADCAST, OnEnbroadcast)
	ON_BN_CLICKED(IDC_DEBROADCAST, OnDebroadcast)
	ON_BN_CLICKED(IDC_ALARM, OnAlarm)
	ON_BN_CLICKED(IDC_ALARMOUTLOGIC, OnAlarmoutlogic)
	ON_BN_CLICKED(IDC_ALARMOUTLOGICL, OnAlarmoutlogicl)
	ON_EN_CHANGE(IDC_ALARMOUT, OnChangeAlarmout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSYSPARAM message handlers

void CSYSPARAM::OnBtnLoadfsparam() 
{//The system parameter file uploaded to the host
	UpdateData();
	adt8840a_upload_sysfile(devnum,1,"",&syspara);
    ShowSystemParam();
	UpdateData(FALSE);	
}

void CSYSPARAM::OnBtnWrtfsparam() 
{//Save current settings to the file system
	UpdateData();
	CDEMODlg* pDlg=(CDEMODlg*)(this->GetParent());
	if(!pDlg->m_nFSpdMode)
	{
		adt8840a_download_sysfile(devnum,0,&syspara,"");
		AfxMessageBox("The current system parameters have been updated but not saved as system configuration files, \ n For more information is saved as system configuration files, operating at fixed speed mode!");
	}
	else 
	{
		SaveSysParam(m_nAxisNum);	
		adt8840a_download_sysfile(devnum,1,&syspara,"");
		AfxMessageBox("Save the system parameters for system configuration files OK!");	
	}	
}

int CSYSPARAM::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	adt8840a_upload_sysfile(devnum,0,"",&syspara);
    ShowSystemParam();

	return 0;
}

void CSYSPARAM::ShowSystemParam()
{
    //adt8840a_upload_sysfile(devnum,1,"",&syspara);
	// Back to the origin initiation speed, drive speed, acceleration		
	m_fHomeStartSpd = syspara.fHomeStartv[m_nAxisNum];	
	m_fHomeRunSpd   = syspara.fHomeSpeed[m_nAxisNum];
	m_fHomeAddtime  = syspara.fHomeAccTime[m_nAxisNum];
	//Back to the origin search speed, search
	m_fSearchSpd    = syspara.fHomelSpeed[m_nAxisNum];
	m_fSearchRang   = syspara.fHomelRange[m_nAxisNum];
	//Initiation processing speed, drive speed, acceleration
	m_fWorkAddtime  = syspara.fAccTime[m_nAxisNum];
	m_fWorkRunSpd   = syspara.fSpeed[m_nAxisNum];
	m_fWorkStartSpd = syspara.fStartv[m_nAxisNum];
	//Pulse equivalent
	m_lPusleUnit    = syspara.lPulseMm[m_nAxisNum];	
	//Back to the origin of the function set, Z believe the number
	m_bHomeStop0    = syspara.home[m_nAxisNum];
	m_nHomeLevel    = syspara.home_logic[m_nAxisNum];
	m_bZPhasic      = syspara.ucZi[m_nAxisNum];	
	m_nZPhasicLevel = syspara.Zi_logic[m_nAxisNum];
	m_bhomeaxis		= syspara.home_setup[m_nAxisNum];
	m_homestep		= syspara.home_step[m_nAxisNum];
	//Pulse settings work
	m_nPulseMode    = syspara.pulse_mode[m_nAxisNum];
	m_nPulseLog     = syspara.pulse_logic[m_nAxisNum];
	m_nDirLogic     = syspara.dir_logic[m_nAxisNum];
	//Work settings limit
	m_bLimitN       = syspara.limit_neg[m_nAxisNum];
	m_bLimitP       = syspara.limit_pos[m_nAxisNum];
	m_nLimitLevel   = syspara.limit_logic[m_nAxisNum];

	m_alarm			= syspara.en_alarm[m_nAxisNum];
	m_alarmlogic	= syspara.alarm_logic[m_nAxisNum];
	m_alarm_out		= syspara.alarm_out;
	m_alarm_out_logic =syspara.alarm_out_logic;
	m_enbroadcast   = syspara.en_broadcast;

}

void CSYSPARAM::SaveSysParam(int Axis)
{

	UpdateData();
	// Back to the origin initiation speed, drive speed, acceleration
	syspara.fHomeStartv[m_nAxisNum]	 = m_fHomeStartSpd;
	syspara.fHomeSpeed[m_nAxisNum]   = m_fHomeRunSpd;
	syspara.fHomeAccTime[m_nAxisNum] = m_fHomeAddtime;
	//Back to the origin search speed, search
	syspara.fHomelSpeed[m_nAxisNum]	 = m_fSearchSpd;
	syspara.fHomelRange[m_nAxisNum]	 = m_fSearchRang ;
	//Initiation processing speed, drive speed, acceleration
	syspara.fAccTime[m_nAxisNum]     = m_fWorkAddtime;
	syspara.fSpeed[m_nAxisNum]	     = m_fWorkRunSpd;
	syspara.fStartv[m_nAxisNum]	     = m_fWorkStartSpd;	
	//Pulse equivalent
	syspara.lPulseMm[m_nAxisNum]     = m_lPusleUnit;   
	//Back to the origin of the function set, Z believe the number
	syspara.home[m_nAxisNum]	     = m_bHomeStop0;
	syspara.home_logic[m_nAxisNum]	 = m_nHomeLevel ;
	syspara.ucZi[m_nAxisNum]         = m_bZPhasic ;
	syspara.Zi_logic[m_nAxisNum]	 = m_nZPhasicLevel;
	syspara.home_setup[m_nAxisNum]   = m_bhomeaxis ;
	syspara.home_step[m_nAxisNum]	 = m_homestep;
	//Work set the pulse	
	syspara.pulse_mode[m_nAxisNum]	 = m_nPulseMode ;
	syspara.pulse_logic[m_nAxisNum]	 = m_nPulseLog ;
	syspara.dir_logic[m_nAxisNum]	 = m_nDirLogic ;
	//Work settings limit
	syspara.limit_neg[m_nAxisNum]	 = m_bLimitN ;
	syspara.limit_pos[m_nAxisNum]	 = m_bLimitP ;
	syspara.limit_logic[m_nAxisNum]	 = m_nLimitLevel ;

	syspara.en_alarm[m_nAxisNum]=m_alarm;
	syspara.alarm_logic[m_nAxisNum]=m_alarmlogic;
	syspara.alarm_out=m_alarm_out	;
	syspara.alarm_out_logic=m_alarm_out_logic;
	syspara.en_broadcast=m_enbroadcast;
}

void CSYSPARAM::OnRadioAxisX() 
{//X-axis
	UpdateData();
	ShowSystemParam();	//뵱ǰ
	UpdateData(FALSE);	
}

void CSYSPARAM::OnRadioAxisY() 
{//Y-axis
	UpdateData();
	ShowSystemParam();	
	UpdateData(FALSE);	
}

void CSYSPARAM::OnRadioAxisZ() 
{//Z-axis
	UpdateData();
	ShowSystemParam();
	UpdateData(FALSE);	
}

void CSYSPARAM::OnRadioAxisA() 
{//A-axis
	UpdateData();
	ShowSystemParam();	
	UpdateData(FALSE);
}

void CSYSPARAM::OnCheckLimitp() 
{//LMT+
	UpdateData();	
	syspara.limit_pos[m_nAxisNum]	 = m_bLimitP ;			
}

void CSYSPARAM::OnCheckLimitn() 
{//LMT-
	UpdateData();		
	syspara.limit_neg[m_nAxisNum]	 = m_bLimitN ;
}

void CSYSPARAM::OnCheckHome() 
{//Origin
	UpdateData();	
	syspara.home[m_nAxisNum]	     = m_bHomeStop0;		
}

void CSYSPARAM::OnCheckZphasic() 
{//Z-phase

	UpdateData();		
	syspara.ucZi[m_nAxisNum]         = m_bZPhasic ;	
}

void CSYSPARAM::OnRadioPulsemode0() 
{//Pulse mode0
	UpdateData();
	syspara.pulse_mode[m_nAxisNum]	 = m_nPulseMode ;	
}

void CSYSPARAM::OnRadioPulsemode1() 
{//Pulse mode1
	UpdateData();
	syspara.pulse_mode[m_nAxisNum]	 = m_nPulseMode ;	
}

void CSYSPARAM::OnRadioPulselog0() 
{//Pulse mode logic 0
	UpdateData();
	syspara.pulse_logic[m_nAxisNum]	 = m_nPulseLog ;	
}

void CSYSPARAM::OnRadioPulselog1() 
{//Pulse mode logic 1
	UpdateData();
	syspara.pulse_logic[m_nAxisNum]	 = m_nPulseLog ;	
}

void CSYSPARAM::OnRadioDirlogic0() 
{//Pulse direction signal logic 0
	UpdateData();
	syspara.dir_logic[m_nAxisNum]	 = m_nDirLogic ;		
}

void CSYSPARAM::OnRadioDirlogic1() 
{//Pulse direction signal logic 1
	UpdateData();
	syspara.dir_logic[m_nAxisNum]	 = m_nDirLogic ;		
}

void CSYSPARAM::OnRadioLmtLevel0() 
{//Limit the effective level0
	UpdateData();
    syspara.limit_logic[m_nAxisNum]	 = m_nLimitLevel ;		
}

void CSYSPARAM::OnRadioLmtLevel1() 
{//Limit the effective level1
	UpdateData();
    syspara.limit_logic[m_nAxisNum]	 = m_nLimitLevel ;	
}

void CSYSPARAM::OnRadioHomeLevel0() 
{//Origin of the effective level 0
	UpdateData();
	syspara.home_logic[m_nAxisNum]	 = m_nHomeLevel ;	
}

void CSYSPARAM::OnRadioHomeLevel1() 
{//Origin of the effective level 1
	UpdateData();
	syspara.home_logic[m_nAxisNum]	 = m_nHomeLevel ;	
}

void CSYSPARAM::OnRadioZphasicLevel0() 
{//With the effective level Z 0
 	UpdateData();
 	syspara.Zi_logic[m_nAxisNum]	 = m_nZPhasicLevel;		
}

void CSYSPARAM::OnRadioZphasicLevel1() 
{//With the effective level Z 1
	UpdateData();
	syspara.Zi_logic[m_nAxisNum]	 = m_nZPhasicLevel;	
}

void CSYSPARAM::OnChangeHomeStartSpeed() 
{
	UpdateData();
	syspara.fHomeStartv[m_nAxisNum]	 = m_fHomeStartSpd;
}

void CSYSPARAM::OnChangeWorkStartSpeed() 
{
	UpdateData();
	syspara.fStartv[m_nAxisNum]	     = m_fWorkStartSpd;
}

void CSYSPARAM::OnChangeHomeRunSpeed() 
{
	UpdateData();
	syspara.fHomeSpeed[m_nAxisNum]   = m_fHomeRunSpd;
}

void CSYSPARAM::OnChangeWorkRunSpeed() 
{
	UpdateData();
	syspara.fSpeed[m_nAxisNum]	     = m_fWorkRunSpd;
}

void CSYSPARAM::OnChangeWorkAddTime() 
{
	UpdateData();
	syspara.fAccTime[m_nAxisNum]     = m_fWorkAddtime;	
}

void CSYSPARAM::OnChangeHomeAddTime() 
{
	UpdateData();
	syspara.fHomeAccTime[m_nAxisNum] = m_fHomeAddtime;
}

void CSYSPARAM::OnChangeSearchSpeed() 
{
	UpdateData();
	syspara.fHomelSpeed[m_nAxisNum]	 = m_fSearchSpd;
}

void CSYSPARAM::OnChangeSearchRange() 
{
	UpdateData();
	syspara.fHomelSpeed[m_nAxisNum]	 = m_fSearchSpd;
}

void CSYSPARAM::OnChangePulseUnit() 
{
	UpdateData();
}

void CSYSPARAM::OnCheckBhome() 
{
	UpdateData();
	syspara.home_setup[m_nAxisNum]   = m_bhomeaxis ;
}

void CSYSPARAM::OnChangeStep() 
{
	UpdateData();
	syspara.home_step[m_nAxisNum]	 = m_homestep;
}

void CSYSPARAM::OnALARM_LOGIL() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	syspara.alarm_logic[m_nAxisNum]=m_alarmlogic;
}

void CSYSPARAM::OnALARM_LOGIH() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	syspara.alarm_logic[m_nAxisNum]=m_alarmlogic;
}

void CSYSPARAM::OnEnbroadcast() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	syspara.en_broadcast=m_enbroadcast;
}

void CSYSPARAM::OnDebroadcast() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	syspara.en_broadcast=m_enbroadcast;
}

void CSYSPARAM::OnAlarm() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	syspara.en_alarm[m_nAxisNum]=m_alarm;
}

void CSYSPARAM::OnAlarmoutlogic() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	syspara.alarm_out_logic=m_alarm_out_logic;
}


void CSYSPARAM::OnAlarmoutlogicl() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	syspara.alarm_out_logic=m_alarm_out_logic;
}

void CSYSPARAM::OnChangeAlarmout() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	UpdateData();
	syspara.alarm_out=m_alarm_out;
}





















